<?php
$html_head = <<<htmlhead
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Moja strona WWW</title>
  </head>
  <body>
htmlhead;

$html_foot = <<<htmlfoot
  </body>
</html>
htmlfoot;

$nofile = <<<nofile
<p style="text-align:center">Nie ma takiego pliku na serwerze!</p>
<p style="text-align:center"> 
  <a href="http://localhost/download.html">Powrót do strony pobrań</a>
</p>
nofile;

  $filesPath = "/var/wwwdata/downloads/";
  $ext = array(".jpg", ".gif", ".png");

  //Funkcja sprawdzająca poprawność nazwy
  function checkFileName($name, $path)
  {
    $fd = opendir($path);
    if(!$fd) return false;
    while (($file = readdir($fd)) !== false){
      if(is_dir($path.$file)) continue;
      if($file == $name) return true;
    }
    closedir($fd);
    return false;
  }

  //Funkcja wysyłająca plik
  function send($fileName, $filePath)
  {
    if(!file_exists($filePath.$fileName)){
      return false;
    }
    $fd = fopen($filePath.$fileName, "r");
    $size = filesize($filePath.$fileName);
    $contents = fread($fd, filesize($filePath.$fileName));
    if($contents === false){
      return false;
    }

    fclose($fd);

    header("Content-Type: application/octet-stream");
    header("Content-Length: $size;");
    header("Content-Disposition: attachment; filename=$fileName");

    echo $contents;
    return true;
  }

  //Funkcja wyświetląjaca listę plików
  function printList($path, $ext)
  {
    $fd = opendir($path);
    if(!$fd) return false;
    echo "<ul>";
    while (($file = readdir($fd)) !== false){
      if(is_dir($path.$file)) continue;
      if(($pos = strrpos($file, '.')) && !in_array(strtolower(substr($file, $pos)), $ext)) continue;
      echo("<li><a href=\"http://localhost/download.php?name=");
      echo("$file\">$file</a></li>");
    }
    echo "</ul>";
    closedir($fd);
  }
  
  //Odczytanie danych i wywołanie funkcji
  if(isset($_GET['name'])){
    if(checkFileName($_GET['name'], $filesPath) === false){
      echo $html_head;
      echo $nofile;
      echo $html_foot;
    }
    else{
      if(!send($_GET['name'], $filesPath)){
        echo $html_head;
        echo $nofile;
        echo $html_foot;
      }
    }
  }
  else{
    echo $html_head;
    printList($filesPath, $ext);
    echo $html_foot;
  }
?>
